<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Landing Page Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used throughout the landing page
    | components for various messages and labels.
    |
    */

    // Hero Section
    'hero' => [
        'pill_no_coding' => 'No coding required',
        'pill_5_minute_setup' => '5-minute setup',
        'pill_free_tier' => 'Free tier available',
        'headline' => 'Build Native Apps',
        'headline_highlight' => 'in Minutes',
        'subheadline' => 'Transform your website into native apps for any platform.',
        'subheadline_ai' => 'AI-powered',
        'subheadline_features' => 'configuration, custom branding, push notifications, and automated builds. No coding required.',
        'cta_get_started' => 'Get started free',
        'cta_view_pricing' => 'View pricing',
        'stat_developers' => 'Developers',
        'stat_apps_built' => 'Apps Built',
        'stat_builds_generated' => 'Builds Generated',
        'rating_text' => '4.9/5 from 200+ reviews',
        'phone_app_name' => 'My App',
        'phone_app_type' => 'Mobile',
        'laptop_title' => 'My App — Dashboard',
    ],

    // Features Section
    'features' => [
        'title' => 'Everything you need to build amazing apps',
        'subtitle' => 'Powerful features and tools to transform your website into professional native applications without writing a single line of code.',

        'multi_platform_title' => 'Multi-Platform Support',
        'multi_platform_desc' => 'Build native apps for Android, Windows, macOS, and Linux. Generate platform-specific packages ready for distribution on any app store.',

        'easy_config_title' => 'Easy Configuration',
        'easy_config_desc' => 'Intuitive interface to customize your app design, navigation, colors, icons, splash screens, and more without any coding required.',

        'branding_title' => 'Complete Branding Control',
        'branding_desc' => 'Customize app icons, splash screens, themes, colors, and inject custom HTML, CSS, and JavaScript for full control.',

        'push_notifications_title' => 'Push Notifications',
        'push_notifications_desc' => 'Engage users with Firebase Cloud Messaging push notifications. Send targeted messages to your app users directly from your dashboard.',

        'build_system_title' => 'Automated Build System',
        'build_system_desc' => 'Build your apps with a single click. Our distributed build system generates platform-specific packages automatically, ready for distribution.',

        'app_signing_title' => 'Secure App Signing',
        'app_signing_desc' => 'Upload and manage signing certificates securely. Sign your release builds for app store distribution with confidence.',

        'version_management_title' => 'Version Management',
        'version_management_desc' => 'Manage multiple app versions with build history. Track changes, rollback when needed, and maintain version control effortlessly.',

        'qr_testing_title' => 'QR Code Testing',
        'qr_testing_desc' => 'Test your apps instantly with QR code downloads. Share builds with testers and clients before publishing to app stores.',

        'build_tracking_title' => 'Build Tracking',
        'build_tracking_desc' => 'Monitor build status in real-time with detailed logs. Track build duration, errors, and download previous versions anytime.',

        'ai_assistant_title' => 'AI-Powered Assistant',
        'ai_assistant_desc' => 'Get intelligent help configuring your app. Our AI assistant can automatically set up navigation, colors, and settings based on your website.',

        'api_access_title' => 'API Access',
        'api_access_desc' => 'Integrate with your workflow using our comprehensive API. Automate app creation, trigger builds, and manage notifications programmatically.',

        'hosted_pages_title' => 'Hosted Pages',
        'hosted_pages_desc' => 'Embed custom HTML pages directly in your app. Create about pages, FAQs, terms of service, and more with full design control.',
    ],

    // How It Works Section
    'how_it_works' => [
        'default_title' => 'How It Works',
        'default_subtitle' => 'Build your mobile app in 4 simple steps',

        'step1_title' => 'Enter Your URL',
        'step1_desc' => 'Paste your website URL and we\'ll automatically analyze it to get you started quickly.',

        'step2_title' => 'Customize Design',
        'step2_desc' => 'Choose colors, icons, splash screens, and navigation style. Use AI assistance for quick setup.',

        'step3_title' => 'Build Your App',
        'step3_desc' => 'One-click build with our distributed system. Get native builds in minutes.',

        'step4_title' => 'Download & Publish',
        'step4_desc' => 'Download your app or scan QR code to test. Ready for app store publishing.',
    ],

    // Pricing Section
    'pricing' => [
        'default_title' => 'Simple, transparent pricing',
        'default_description' => 'Choose the perfect plan for your needs. All plans include core features with different build credit allocations.',
        'default_popular_badge' => 'Most Popular',
        'default_free_text' => 'Free',
        'default_no_plans' => 'Pricing plans coming soon. Please check back later.',
        'start_free' => 'Start Free',
        'go_pro' => 'Go Pro',
        'get_enterprise' => 'Get Enterprise',
    ],

    // Testimonials Section
    'testimonials' => [
        'default_title' => 'What Our Customers Say',
        'default_subtitle' => 'Join thousands of satisfied developers and businesses',
        'anonymous' => 'Anonymous',
    ],

    // CTA Section
    'cta' => [
        'title' => 'Start building your app today',
        'subtitle' => 'Join thousands of developers and businesses who trust :site_name to build their apps. No credit card required.',
        'button' => 'Get started free',
    ],

    // Footer Section
    'footer' => [
        'tagline' => 'Build native apps from your website in minutes. Professional app builder with no coding required.',
        'privacy_policy' => 'Privacy Policy',
        'terms_of_service' => 'Terms of Service',
        'cookie_policy' => 'Cookie Policy',
        'copyright' => '© :year. All Rights Reserved.',
    ],

    // Social Proof Section
    'social_proof' => [
        'happy_developers' => 'Happy developers',
        'apps_created' => 'Apps created',
        'builds_generated' => 'Builds generated',
    ],

    // Logos Section
    'logos' => [
        'title' => "You'll be in good company",
    ],

    // Page Titles
    'page_title' => 'Build Native Mobile Apps in Minutes',
];
